﻿$Computers = Get-Content "C:\Temp\Server.txt"

$results = foreach ($computer in $Computers)
{
    If (Test-Connection -ComputerName $computer -Count 1 -Quiet)
    {
        Try {

        Invoke-Command -computername $Computer -ScriptBlock {
        
        $registryPath = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System\CredSSP\Parameters"
        $name = "AllowEncryptionOracle"
        $value = "2"

        If (-NOT (Test-Path $registryPath)) {
        New-Item $registryPath  -ErrorAction 'Stop' | Out-Null
        }

        New-ItemProperty -Path $registryPath `
        -Name $name `
        -Value $value `
        -PropertyType DWORD `
        -Force | Out-Null
        }

            $status = "Ausgeführt"
        } Catch {
            $status = "Fehlgeschlagen"
        }
    }
    else
    {   
        $status = "nicht erreicht"
    }
    
    New-Object -TypeName PSObject -Property @{
        'Computer'=$computer
        'Status'=$status
    }
}

$results |
Export-Csv -NoTypeInformation -Path "C:\Temp\Result.csv"